<?php

include_once 'conexao.php'; 
  
class ModeloPedidoProfessorOrganizacao
{   
	static public function mdlAddPedidoProfessorOrganizacao($dados){ 
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO pedidoprofessororganizacao 
						(idProfessor, idOrganizacao, dataCadastro,biProfessor,nifOrganizacao,estadoPedido) VALUES 
						(:idProfessor, :idOrganizacao, :dataCadastro,:biProfessor,:nifOrganizacao,:estadoPedido)");
		$stmt->bindParam(":biProfessor", $dados["biProfessor"], PDO::PARAM_STR);
		$stmt->bindParam(":idProfessor", $dados["idProfessor"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idOrganizacao", $dados["idOrganizacao"], PDO::PARAM_STR);
		$stmt->bindParam(":nifOrganizacao", $dados["nifOrganizacao"], PDO::PARAM_STR);
		$stmt->bindParam(":estadoPedido", $dados["estadoPedido"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}  
 
	static public function mdlMostrarPedidoDaOrganizacaoParaProfessor($idOrganizacao,$nifOrganizacao,$idProfessor) {

	$resultado = array(); 

	$stmt = Conexao::conectar()->prepare("SELECT * FROM pedidoprofessororganizacao where idOrganizacao = :idOrganizacao and nifOrganizacao = :nifOrganizacao and idProfessor = :idProfessor");
	$stmt->bindParam(":idOrganizacao", $idOrganizacao, PDO::PARAM_STR);
	$stmt->bindParam(":nifOrganizacao", $nifOrganizacao, PDO::PARAM_STR);
	$stmt->bindParam(":idProfessor", $idProfessor, PDO::PARAM_STR);
	$stmt ->execute();

	$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
	return $resultado;

	}
	
	static public function mdlMostrarPedidoDaOrganizacaoParaProfessorPoridPedidoProfessorOrganozacao($idPedidoProfessorOrganozacao) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM pedidoprofessororganizacao where idPedidoProfessorOrganozacao = :idPedidoProfessorOrganozacao");
		$stmt->bindParam(":idPedidoProfessorOrganozacao", $idPedidoProfessorOrganozacao, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}
	static public function mdlMostrarTodosPedidoDaOrganizacaoParaProfessorPorIdOrganizacao($idOrganizacao) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM pedidoprofessororganizacao where idOrganizacao = :idOrganizacao");
		$stmt->bindParam(":idOrganizacao", $idOrganizacao, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}
  
	static public function mdlMostrarTodosInstrutoresDaOrganizacaoPorIdOrganizacaoEEstadoPedido($idOrganizacao, $estadoPedido) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM pedidoprofessororganizacao where idOrganizacao = :idOrganizacao and estadoPedido = :estadoPedido");
		$stmt->bindParam(":idOrganizacao", $idOrganizacao, PDO::PARAM_STR);
		$stmt->bindParam(":estadoPedido", $estadoPedido, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarTodosOsPedidosFeitosPelaInstituicoesParaOInstrutor($idProfessor, $estadoPedido) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM pedidoprofessororganizacao where idProfessor = :idProfessor and estadoPedido = :estadoPedido");
		$stmt->bindParam(":idProfessor", $idProfessor, PDO::PARAM_STR);
		$stmt->bindParam(":estadoPedido", $estadoPedido, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlActualizarEstadoPedidoOrganizacao($idPedidoProfessorOrganozacao, $estadoPedido) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("UPDATE pedidoprofessororganizacao set estadoPedido = :estadoPedido where idPedidoProfessorOrganozacao = :idPedidoProfessorOrganozacao");
		$stmt->bindParam(":idPedidoProfessorOrganozacao", $idPedidoProfessorOrganozacao, PDO::PARAM_STR);
		$stmt->bindParam(":estadoPedido", $estadoPedido, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}


	static public function mdlEliminarPedidoPorIdPedidoProfessorOrganozacao($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM pedidoprofessororganizacao where idPedidoProfessorOrganozacao = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>